


CREATE OR REPLACE FUNCTION public.ufd_juros_cli(cd_cli bigint, saldodupl numeric, vencto date, dt_prorrog date, dt_pag date, juros_pagos_ant numeric, juros_pagos_amort numeric, amort_juros numeric)
 RETURNS numeric
 LANGUAGE plpgsql
AS $function$  
  declare
		bint_cd_cli   alias for $1;
		dbl_saldo    alias for $2;
		vencto   alias for $3;
		dt_prorrog  alias for $4;
		dt_pag  alias for $5;
		juros_pagos_ant alias for $6;
		juros_pagos_amort alias for $7;
		int_dias integer;
		dbl_multa numeric;
		dbl_juros numeric;
		dias numeric;
		saldo numeric default 0;
		dt_nvo_vencto date;
		JurosCalculado numeric default 0;
begin
	select   
		coalesce(m.dias_caren_atraso,0), 
		perc_juros_multa ,
		perc_juros_atraso 
			into int_dias, dbl_multa, dbl_juros 
	from  
		rc_cli_crediario c 
		inner join rc_mdl_venda m on 
		c.cd_emp = m.cd_emp and 
		c.cd_mdl_vd = m.cd_mdl_vd 
	where
		c.cd_cli = bint_cd_cli;
	IF EXISTS (SELECT 1 FROM prc_emp_config where cd_chave = 'CALCULA_JUROS_A_PARTIR_DO_ULTIMO_PAGAMENTO' AND valor = '0') THEN
		IF FOUND THEN
			dt_nvo_vencto=(case  when dt_prorrog is null then
									(SELECT  vencto::date+cast(int_dias || 'day' as interval))
								else
									dt_prorrog
								end);
			if amort_juros = 0 then			  
				select  DATE_PART('day', now() - dt_nvo_vencto) into dias ;
				if now()::date > dt_nvo_vencto THEN
					saldo =  round( dbl_saldo + ( dbl_saldo * dbl_multa/100 + (dbl_saldo * ((dbl_juros/100)/30) * dias)),2);   
				else
					saldo = dbl_saldo;
				end if;	
			else  	
				JurosCalculado = 	(case when now() >dt_nvo_vencto then
										round(((dbl_saldo * ((dbl_juros/30) * DATE_PART('day', now() - dt_nvo_vencto )))/100)::numeric,2) - juros_pagos_amort         
									else
										0
									end);					
				saldo=round((dbl_saldo + JurosCalculado)::numeric,2);
			end if;	
		END IF;
	ELSE
		IF FOUND THEN
			dt_nvo_vencto=(case  when dt_prorrog is null then
									(case DATE_PART('day', now()-vencto ) > int_dias when true  then
										vencto						
									else
										(SELECT  vencto::date+cast(int_dias || 'day' as interval))
									end)
								else
									dt_prorrog
								end);
			if amort_juros = 0 then			  
				select  DATE_PART('day', now() - dt_nvo_vencto) into dias ;
				if now()::date > dt_nvo_vencto THEN
					saldo =  round( dbl_saldo + ( dbl_saldo * dbl_multa/100 + (dbl_saldo * ((dbl_juros/100)/30) * dias)),2);   
				else
					saldo = dbl_saldo;
				end if;	
			else  	
				JurosCalculado = (case when dt_pag is null then					
										(case when now()::date >dt_nvo_vencto then
											round(((dbl_saldo * dbl_multa)/100)::numeric,2) + 
											round(((dbl_saldo * ((dbl_juros/30) *  DATE_PART('day', now() - dt_nvo_vencto )))/100)::numeric,2) - juros_pagos_ant        
										else
											0
										end)
									else
										(case when dt_pag < dt_nvo_vencto then
											(case when now() >dt_nvo_vencto then
												round(((dbl_saldo * ((dbl_juros/30) * DATE_PART('day', now() - dt_nvo_vencto )))/100)::numeric,2) - juros_pagos_amort         
											else
												0
											end)						
										else
											(case when now()::date > dt_pag then
												round((dbl_saldo * dbl_multa)/100,2)+
												round(((dbl_saldo * ((dbl_juros/30) * DATE_PART('day' , now() - dt_pag )))/100)::numeric,2) - juros_pagos_amort  
											else
												0
											end)
										end)
									end);		
					saldo=round((dbl_saldo + JurosCalculado)::numeric,2);
			end if;	
		END IF;
	END IF;
	return saldo;		
end;
$function$
;